﻿using gov.va.med.vbecs.Common.Configuration;

namespace gov.va.med.vbecs.Common.AppServices
{
    /// <summary>
    /// The Global context exposes classes and data that can be used by our server components, 
    /// they are request agnostic and are kept alive along with the application. 
    /// A good approach with these global resources and services is not keeping any sort of state if feasible, 
    /// concurrency issues may arise if the design is not correct.
    /// </summary>
    public interface IGlobalContext
    {
        /// <summary>
        /// Returns application settings reader object
        /// </summary>
        IAppSettingsReader AppSettingsReader { get; }

        /// <summary>
        /// Returns database settings reader object
        /// </summary>
        IDbSettingsReader DbSettingsReader { get; }
    }
}
